// Node.js环境下的DOI提取测试
console.log("开始测试DOI提取功能...\n");

// DOI提取函数（简化版本，适用于Node.js环境）
function extractDOI(url) {
    console.log("开始提取DOI信息...");
    
    // 从URL中提取DOI
    const urlDoiPattern = /\/doi\/(10\.\d+\/[^\s?#]+)/i;
    const urlMatch = url.match(urlDoiPattern);
    
    if (urlMatch) {
        const doi = urlMatch[1];
        console.log("从URL中提取到DOI:", doi);
        return doi;
    }
    
    console.log("未检测到DOI信息");
    return null;
}

// 测试用例
const testCases = [
    {
        name: "Science.org DOI URL",
        url: "https://www.science.org/doi/10.1126/sciadv.adr9635",
        expected: "10.1126/sciadv.adr9635"
    },
    {
        name: "带查询参数的DOI URL",
        url: "https://example.com/doi/10.1234/abc.def?param=value",
        expected: "10.1234/abc.def"
    },
    {
        name: "带锚点的DOI URL",
        url: "https://example.com/doi/10.1234/abc.def#section",
        expected: "10.1234/abc.def"
    },
    {
        name: "普通网页URL",
        url: "https://example.com/page/123",
        expected: null
    },
    {
        name: "Nature文章URL",
        url: "https://www.nature.com/articles/10.1038/s41586-023-06447-0",
        expected: null  // 这个URL格式不包含/doi/路径
    }
];

console.log("=== 测试URL中的DOI提取 ===");
let passedTests = 0;
let totalTests = testCases.length;

testCases.forEach((testCase, index) => {
    console.log(`\n测试用例 ${index + 1}: ${testCase.name}`);
    console.log(`URL: ${testCase.url}`);
    
    const result = extractDOI(testCase.url);
    const success = result === testCase.expected;
    
    if (success) {
        console.log(`✅ 通过 - 期望: ${testCase.expected || 'null'}, 实际: ${result || 'null'}`);
        passedTests++;
    } else {
        console.log(`❌ 失败 - 期望: ${testCase.expected || 'null'}, 实际: ${result || 'null'}`);
    }
});

console.log(`\n=== 测试完成 ===");
console.log(`总测试数: ${totalTests}`);
console.log(`通过测试: ${passedTests}`);
console.log(`失败测试: ${totalTests - passedTests}`);
console.log(`成功率: ${((passedTests / totalTests) * 100).toFixed(1)}%`);

// 特别测试你提到的URL
console.log("\n=== 特别测试你提到的URL ===");
const yourUrl = "https://www.science.org/doi/10.1126/sciadv.adr9635";
const yourDoi = extractDOI(yourUrl);
console.log(`你的URL: ${yourUrl}`);
console.log(`提取的DOI: ${yourDoi}`);
console.log(`测试结果: ${yourDoi === "10.1126/sciadv.adr9635" ? "✅ 成功" : "❌ 失败"}`);
