// DOI提取功能测试脚本
console.log("开始测试DOI提取功能...");

// 模拟extractDOI函数
function extractDOI() {
    console.log("开始提取DOI信息...");
    
    // 首先尝试从当前URL中提取DOI
    const currentUrl = window.location.href;
    const urlDoiPattern = /\/doi\/(10\.\d+\/[^\s?#]+)/i;
    const urlMatch = currentUrl.match(urlDoiPattern);
    
    if (urlMatch) {
        const doi = urlMatch[1];
        console.log("从URL中提取到DOI:", doi);
        return doi;
    }
    
    // 从当前页面HTML中提取DOI
    const doiPatterns = [
        /DOI:\s*(10\.\d+\/[^\s]+)/i,           // 标准DOI格式
        /10\.\d+\/[^\s]+/i,                     // 纯DOI格式
        /doi:\s*(10\.\d+\/[^\s]+)/i            // 小写doi
    ];
    
    for (let pattern of doiPatterns) {
        const match = document.documentElement.innerHTML.match(pattern);
        if (match) {
            const doi = match[1] || match[0];
            console.log("从页面内容中提取到DOI:", doi);
            return doi;
        }
    }
    
    console.log("未检测到DOI信息");
    return null;
}

// 测试用例
const testUrls = [
    "https://www.science.org/doi/10.1126/sciadv.adr9635",
    "https://example.com/doi/10.1234/abc.def?param=value",
    "https://example.com/doi/10.1234/abc.def#section",
    "https://example.com/page/123",
    "https://www.nature.com/articles/10.1038/s41586-023-06447-0"
];

console.log("\n=== 测试URL中的DOI提取 ===");
testUrls.forEach((url, index) => {
    console.log(`\n测试用例 ${index + 1}: ${url}`);
    
    // 模拟window.location.href
    const originalHref = window.location.href;
    Object.defineProperty(window, 'location', {
        value: { href: url },
        writable: true
    });
    
    const doi = extractDOI();
    if (doi) {
        console.log(`✅ 成功提取DOI: ${doi}`);
    } else {
        console.log(`❌ 未提取到DOI`);
    }
    
    // 恢复原始href
    Object.defineProperty(window, 'location', {
        value: { href: originalHref },
        writable: true
    });
});

console.log("\n=== 测试完成 ===");
