host = 'https://www.uping365.cn';
//host = 'http://127.0.0.1:5000';

// 在页面上下文中注入并提取 DOI（返回 Promise 结果）- 兼容 MV3/MV2/Firefox
function detectDOIInPage(tabId, timeoutMs, callback) {
    const maxWait = timeoutMs || 6000;
    const api = typeof browser !== 'undefined' ? browser : (typeof chrome !== 'undefined' ? chrome : null);
    if (!api) {
        console.log('执行页面 DOI 识别时异常: 无可用的浏览器扩展 API');
        callback(null); return;
    }

    // 将检测函数定义为可注入的字符串，以便 tabs.executeScript 也能使用
    const detector = function(maxWaitMs) {
        function scanOnce() {
            try {
                const urlMatch = window.location.href.match(/\/doi\/(10\.\d+\/[^\s?#]+)/i);
                if (urlMatch) return urlMatch[1];
            } catch(e){}
            try {
                const el = document.querySelector('.doiStyle a, [data-doi], a[href^="https://doi.org/"], a[href^="http://doi.org/"]');
                if (el) {
                    const text = (el.getAttribute('data-doi') || el.textContent || '').trim();
                    const m = text.match(/10\.\d+\/[^\s]+/);
                    if (m) return m[0];
                }
            } catch(e){}
            try {
                const meta = document.querySelector('meta[name="citation_doi"], meta[property="doi"]');
                if (meta) {
                    const content = meta.getAttribute('content') || '';
                    const m = content.match(/10\.\d+\/[^\s]+/);
                    if (m) return m[0];
                }
            } catch(e){}
            try {
                const html = document.documentElement.innerHTML;
                const pats = [
                    /DOI:\s*(10\.\d+\/[^\s]+)/i,
                    /"doi":\s*"(10\.\d+\/[^"]+)"/i,
                    /'doi':\s*'(10\.\d+\/[^']+)'/i,
                    /(10\.\d+\/[^\s"'<>]+)/i
                ];
                for (const p of pats) {
                    const m = html.match(p);
                    if (m) return m[1] || m[0];
                }
            } catch(e){}
            try {
                const walker = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
                let node;
                while (node = walker.nextNode()) {
                    const t = (node.textContent || '').trim();
                    const m = t.match(/10\.\d+\/[^\s]+/);
                    if (m) return m[0];
                }
            } catch(e){}
            return null;
        }
        let found = scanOnce();
        if (found) return found;
        return new Promise(resolve => {
            const deadline = Date.now() + maxWaitMs;
            let stopped = false;
            const tryResolve = () => {
                if (stopped) return;
                const v = scanOnce();
                if (v) { stopped = true; resolve(v); }
                else if (Date.now() > deadline) { stopped = true; resolve(null); }
            };
            let observer;
            try {
                observer = new MutationObserver(() => tryResolve());
                observer.observe(document.documentElement || document.body, { childList: true, subtree: true, characterData: true });
            } catch(e){}
            const poll = setInterval(tryResolve, 400);
            setTimeout(() => {
                try { observer && observer.disconnect(); } catch(e){}
                clearInterval(poll);
                tryResolve();
            }, maxWaitMs);
        });
    };

    const funcStr = '(' + detector.toString() + ')(' + JSON.stringify(maxWait) + ')';

    try {
        if (api.scripting && api.scripting.executeScript) {
            api.scripting.executeScript({
                target: { tabId: tabId },
                func: detector,
                args: [maxWait]
            }, (results) => {
                const val = results && results[0] ? results[0].result : null;
                if (val) console.log('页面上下文识别到DOI:', val); else console.log('页面上下文未识别到DOI');
                callback(val || null);
            });
            return;
        }
        if (api.tabs && api.tabs.executeScript) {
            api.tabs.executeScript(tabId, { code: funcStr }, (results) => {
                // Firefox 返回结果数组；MV2 也返回数组
                const val = results && results.length ? results[0] : null;
                if (val) console.log('页面上下文识别到DOI:', val); else console.log('页面上下文未识别到DOI');
                callback(val || null);
            });
            return;
        }
        console.log('执行页面 DOI 识别时异常: 不支持的注入方式');
        callback(null);
    } catch (e) {
        console.log('执行页面 DOI 识别时异常:', e);
        callback(null);
    }
}

$(document).ready(function(){

    get_user_info();

    $(".visit_uping").click(function () {
        window.open(host+'/homepage');
    });

    // 先拿到当前活动标签页，再在页面上下文里识别 DOI
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        const tab = tabs[0];
        if (!tab) { search(null, null, null); return; }
        detectDOIInPage(tab.id, 6000, function(doi){
            search(null, null, doi);
        });
    });

    $('#comment_submit').click(function () {
        if($('#comments_content').val().toString().trim()==""){
            alert('请发表您的精彩评论吧！');
        }
        else {
            page_comment_add($('#page_id').html(),$('#comments_content').val());
        }

    });

});

// 接收外部传入的 doi
function search(page_id,rate_type, preDetectedDoi){
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        const tab = tabs[0];
        console.log("Search() 开始执行");

        const url = tab ? tab.url : '';
        $('#tab_url').html(encodeURI(url));

        const doi = preDetectedDoi || null;
        
        // 保存DOI到全局变量，供page_add使用
        window.currentPageDOI = doi;

        let queryUrl;
        if (doi) {
            queryUrl = host + "/peanut?doi=" + encodeURIComponent(doi);
            console.log("使用DOI查询:", doi);
        } else {
            queryUrl = host + "/peanut?url=" + encodeURIComponent(url);
            console.log("使用URL查询:", url);
        }

        $.ajax({
            type : "GET",
            contentType: "application/json;charset=UTF-8",
            url : queryUrl,
            success : function(data) {
                console.log("Search() 返回:", data);
                $('#invite_tips2').html('');
                $('.loading_gif').remove();
                $('.page_stats').removeClass('hidden');
                $('#operate_divider').removeClass('hidden')

                if (data && (data.code === 200 || data.code === "200"))
                {
                    $('#page_id').html(data.data.id);
                    $('#page_author_id').html(data.data.author_id);
                    get_page_comments(data.data.id);
                    $('.page_stats .fa-thumbs-up').html(' '+data.data.up_vote);
                    $('.page_stats .fa-thumbs-down').html(' '+data.data.down_vote);

                    $("#dianzan_btn").click(function(){
                        page_rate(data.data.id,"1");
                        $("#dianzan_btn").unbind("click");
                        $(".tucao_button").unbind("click");
                    });
                    $(".tucao_button").click(function(){
                        page_rate(data.data.id,"2");
                        $("#dianzan_btn").unbind("click");
                        $(".tucao_button").unbind("click");
                    });

                    theme_config(data.data.id);
                    get_page_custom_title(data.data.id);
                }
                else if (data && (data.code === 500 || data.code === "500")) {
                    $("#dianzan_btn").click(function(){
                        page_add("1");
                        $("#dianzan_btn").unbind("click");
                        $("#tucao_button").unbind("click");
                    });
                    $(".tucao_button").click(function(){
                        page_add("2");
                        $("#dianzan_btn").unbind("click");
                        $(".tucao_button").unbind("click");
                    });
                    $('#fa-comments').click(function () {
                        alert('评论之前请先点赞或吐槽');
                    });

                    $("#theme_tag_submit").unbind('click');
                    console.log("search()————后台没有返回pageID,即将执行theme_config（不带参数）方法");
                    theme_config("");
                }
                else {
                    var errMsg = (data && (data.msg || data.message)) || '请求失败';
                    alert(errMsg);
                    return;
                }

            },
            error : function(e){
                console.log(e.status);
                console.log(e.responseText);
            }
        });
    });
}

/*吐槽出现下方标签的代码，以及绑定事件*/
function tucaoBtnSubmit_showReason_Bind(page_id) {
    if(buttonBindFlag!="false"){
        var html="<div>点此添加具体的吐槽理由</div>";
        html+="<ul><li><a id='reason_1' class='ui label'>抄袭重复</a></li>";
        html+="<li><a id='reason_2' class='ui label'>陈旧过期</a></li>";
        html+="<li><a id='reason_3' class='ui label'>观点错误</a></li>";
        html+="<li><a id='reason_5' class='ui label'>内容低质</a></li>";
        html+="<li><a id='reason_6' class='ui label'>诱导收费</a></li>";
        html+="<li><a id='reason_4' class='ui label'>其他</a></li></ul>";

        $("#tag_ul_list_box").hide("fast");
        $("#tag_ul_list_box").html(html);
        $("#tag_ul_list_box").css("height","10px");
        $("#tag_ul_list_box").css("width","400px");
        $("#tag_ul_list_box").css("float","left");
        $("#tag_ul_list_box").animate({height:"100px"});
        $("#tag_ul_list_box").animate({width:"400px"});
        setTimeout(function () { $("#tag_ul_list_box").fadeIn(); }, 1000);
    }
    $("#reason_1").click(function(){
        page_rate(page_id,"3");//抄袭重复
        $("#reason_1").unbind("click");
    });
    $("#reason_2").click(function(){
        page_rate(page_id,"4");//陈旧过期
        $("#reason_2").unbind("click");
    });
    $("#reason_3").click(function(){
        page_rate(page_id,"5");//观点错误
        $("#reason_3").unbind("click");
    });
    $("#reason_4").click(function(){
        page_rate(page_id,"6");//其他
        $("#reason_4").unbind("click");
    });
    $("#reason_5").click(function(){
        page_rate(page_id,"7");//其他
        $("#reason_5").unbind("click");
    });
    $("#reason_6").click(function(){
        page_rate(page_id,"8");//其他
        $("#reason_6").unbind("click");
    });

}

/*给点赞、吐槽按钮绑定click操作*/
function dianzan_tucao_btn_bind(page_code,page_id) {
    if(page_code=="500"){
        $("#dianzan_btn").click(function(){
            page_add("1");//page_add（）里面调用了rate且type为1
        });
        $("#tucao_btn").click(function(){
            page_add("2");//page_add（）里面调用了rate且type为2，
        });
    }
    else if(page_code=="200"){
        $("#dianzan_btn").click(function(){
            page_rate(page_id,"1");//无需page_add（），直接调用rate
            $("#dianzan_btn").unbind("click");
            $("#tucao_btn").unbind("click");
        });
        console.log("200-bind tucao click,pageid:"+page_id);
        $("#tucao_btn").click(function(){
            page_rate(page_id,"2");//无需page_add（），直接调用rate
            $("#dianzan_btn").unbind("click");
            $("#tucao_btn").unbind("click");
        });
    }
}

/*执行page_add接口*/
function page_add(rate_type){
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        const tab = tabs[0];
        console.log("  page_add() 开始执行， Title:" + tab.title+" | Url:" + tab.url);
        
        // 直接使用search函数中已经提取的DOI
        const doi = window.currentPageDOI || null;
        console.log("使用已识别的DOI:", doi);
        
        // 执行AJAX请求
        $.ajax({
            type : "POST",//请求方式
            url : host + "/page/add",
            data:{
                'url':tab.url,
                'title':process_title(tab.url,tab.title),
                'doi': doi || ''  // 增加DOI字段
            },
            success : function(data) {
                if(data.code=="200")
                {
                    console.log("  page add() ajax success ==== Code:" + data.code +" | Page id:" + data.data.id);
                    //创建page得到page id才能继续rate
                    page_rate(data.data.id,rate_type);
                }
                else {
                    alert("您可能还没有登录，无法创建记录！");
                    chrome.tabs.create({url: host+'/auth/login'});
                    search();
                }
                return data.data.id;
            },
            error : function(e){
                console.log("page add failed");
            }
        });
    });
}

/*执行page_rate接口，并展现+1动画*/
function page_rate(page_id,rate_type) {
    //rate_type: 1, 2, 3, 4, 5, 6, 7,8 分别代表
    // upvote（点赞）、downvote（吐槽）、reason_1（抄袭、重复）、reason_2（陈旧过期）、reason_3（观点错误）、reason_4（其他）
    // 、reason_5（内容低质）、reason_6(诱导收费）
    /*
    $.ajax({
        type:"POST",
        url:host+"/page/rate",
        data:{
            'page_id':page_id,
            'rate_type':rate_type
        },
        success:function (data) {
            console.log("  Page_rate()====Page_ID:"+page_id+" | Rate_type:"+rate_type+" | ajax success "+"Return code:"+JSON.stringify(data));
            var obj=null;
            switch(rate_type) {
                case "1":obj=$("#dianzan_btn");break;
                case "2":obj=$("#tucao_btn");break;
                case "3":obj=$("#reason_1");break;
                case "4":obj=$("#reason_2");break;
                case "5":obj=$("#reason_3");break;
                case "6":obj=$("#reason_4");break;
                case "7":obj=$("#reason_5");break;
                case "8":obj=$("#reason_6");break;
                default:return;
            }

            if(data.code=="200"){
                //秀+1
                $.tipsBox({
                    obj: $(obj),
                    str: "+ 1",
                    callback: function() {
                        //alert(5);
                    }
                });
            }else if(data.code=="505")
            {
                alert("您已经点赞/吐槽过，谢谢！");
                $("#reason_1").unbind("click");
                $("#reason_2").unbind("click");
                $("#reason_3").unbind("click");
                $("#reason_4").unbind("click");
                $("#reason_5").unbind("click");
                $("#reason_6").unbind("click");
                buttonBindFlag="false";
            }
            else {
                alert("您可能还没有登录，无法点赞/吐槽！");
                chrome.tabs.create({url: host+'/auth/login'});
                buttonBindFlag="false";
            }
            search(page_id,rate_type);
        },
        error:function (e) {
            console.log(e.status);
            console.log(e.responseText);
        }
    });*/


    if(rate_type=='1')
    {
        $('#dianzan_btn').css('background','url(../images/loading.gif) no-repeat center');
        $('#dianzan_btn').css('border','none');
        $('#dianzan_btn').css('box-shadow','none');
    }
    if(rate_type==2){
        $('.tucao_button').html("<img src='../images/loading.gif' style='height:30px;'>");
        $('.tucao_button').css('background','none');
    }

    $.ajax({
        type:"POST",
        url:host+"/page/rate",
        data:{
            'page_id':page_id,
            'rate_type':rate_type
        },
        success:function (data) {
            console.log("  Page_rate() 接口执行成功，目标 Page_ID:"+page_id+" | 操作类型 Rate_type:"+rate_type+" | "+" 返回 code:"+data.code);
            console.log("  JSON stringify: "+JSON.stringify(data));
            if(rate_type=='1'){
                $('#dianzan_btn').css('background','url(../images/dianzan.png)');
                $('#dianzan_btn').css('border','1px solid #23a7f7');
                $('#dianzan_btn').css('box-shadow','2px 2px 2px #909090');
            }
            if(rate_type=='2'){
                $('.tucao_button').html("吐槽一下<div class='fa fa-thumbs-down'></div>");
                $('.tucao_button').css({'background-color':'#ff5044','color':'white'});
            }

            if(data.code=="200"){

                if(rate_type=="1"){
                    var a=$('.page_stats .fa-thumbs-up').html();
                    var b=Number(a);
                    b++;
                    $('.page_stats .fa-thumbs-up').html(b.toString());
                    $('.page_stats .fa-thumbs-up').css('color','#ff5044');
                    setTimeout(function () {
                        $('.page_stats .fa-thumbs-up').css('color','#a5a1a1');
                        search();
                        $('#fa-comments').unbind("click");
                        // 只有点赞才显示 theme 和 mytitle
                        theme_config(page_id);
                        get_page_custom_title(page_id);
                    }, 1000 );

                }
                else if(rate_type=="2"){
                    var a=$('.page_stats .fa-thumbs-down').html();
                    var b=Number(a);
                    b++;
                    $('.page_stats .fa-thumbs-down').html(b.toString());
                    $('.page_stats .fa-thumbs-down').css('color','#ff5044');
                    setTimeout(function () {
                        $('.page_stats .fa-thumbs-down').css('color','#a5a1a1');
                        search();
                        $('#fa-comments').unbind("click");
                    }, 1000 )
                }
                else {

                }
            }else if(data.code=="505")
            {
                alert("您已经点赞/吐槽过，谢谢！");
                $("#dianzan_btn").unbind("click");
                $("#tucao_btn").unbind("click");
            }
            else {
                /*alert("您可能还没有登录，无法点赞/吐槽！");
                chrome.tabs.create({url: host+'/auth/login'});
                buttonBindFlag="false";*/
            }
        },
        error:function (e) {
            console.log(e.status);
            console.log(e.responseText);
        }
    });

}

/*获得当前登录者信息*/
/*将登录者信息插入hiddenDIV以供比对*/
function get_user_info() {
    $.ajax({
        type : "get",
        url : host + "/my/info",
        success : function(responseData) {
            if(responseData.code=="200"){
                $('#my_user_id_from_session').html(responseData.data.my_user_id);
                $('#my_avatar').html(responseData.data.avatar);
                console.log('个人数据返回成功');
            }else{
                alert("个人数据返回失败")
            }
        },
        error : function(e){
            console.log("get_user_info（） failed");
        }
    });
}

/*更新中央doc_Operate区域的主要方法，在这里定义了分数的颜色变化*/
/*在这里根据登录者与page创建者的关系，对tag控件进行了区别显示*/
/*function update_Grade(data) {
    console.log("  update() Grade start==== "+JSON.stringify(data));

    //开始计算得分，展示吐槽理由和对应人数
    var upvote=parseInt(data.data.up_vote);
    var downvote=parseInt(data.data.down_vote);
    ratings_grade = 0;
    if(upvote == 0  && downvote==0){
        ratings_grade=0;
    }else{
     ratings_grade=Math.ceil((upvote/(upvote+downvote))*100);
    }

    var ratings_grade_color="#4082F8";
    var tucao_links_str=data.data.reason_1+"次 抄袭重复| "+data.data.reason_2+"次 陈旧过期| ";
        tucao_links_str+=data.data.reason_3+"次 观点错误| "+data.data.reason_4+"次 其他";
    var more_reasons_str="<form id='form_tags' >";
        more_reasons_str+="<input id='page_id_form_input' name='page_id' value='' style='display: none;'>";
        more_reasons_str+="<div class='tag_span'><ul id='url_tag' class='tagit ui-widget ui-widget-content ui-corner-all'></ul></div>";
        more_reasons_str+="<!--<div id='submit_tag_box'>您修改了Tag，要提交吗？<a id='submit_tag'>确定</a></div>--></form>";

        more_reasons_str+="<div class='more_reasons_box'>";
    //if(data.data.up_vote!="0"){more_reasons_str+="<span class='dianzan_reason'>点赞 "+data.data.up_vote+"</span>";}
    if(data.data.reason_1!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>抄袭重复 "+data.data.reason_1+"</span>";}
    if(data.data.reason_2!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>陈旧过期 "+data.data.reason_2+"</span>";}
    if(data.data.reason_3!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>观点错误 "+data.data.reason_3+"</span>";}
    if(data.data.reason_5!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>内容低质 "+data.data.reason_5+"</span>";}
    if(data.data.reason_6!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>诱导收费 "+data.data.reason_6+"</span>";}
    if(data.data.reason_4!="0"){more_reasons_str+="<span class='tucao_reason ui orange label' style='margin:.5em .5em 0 .5em;width:100px;font-weight: 300;'>其他 "+data.data.reason_4+"</span>";}
    more_reasons_str+="</div>";
    //得分的颜色
    if(66<ratings_grade){ratings_grade_color="#4082F8";}
    if(33<ratings_grade&&ratings_grade<=66){ratings_grade_color="#3e3e3e";}
    if(ratings_grade<=33){ratings_grade_color="#ff0000";}

    var grade_Box_html="";
    grade_Box_html+="<div id=\"ratings_box\" class=\"float_Left\">";
    grade_Box_html+="<div id=\"ratings_grade\" class=\"float_Left\"><span style=\"color:"+ratings_grade_color+"\">"+ratings_grade+"</span></div>";
    /!*grade_Box_html+="<div id=\"ratings_like\" class=\"float_Left\"><i class='thumbs up outline icon'></i>"+upvote+"</div>";
    grade_Box_html+="<div id=\"ratings_diss\" class=\"float_Left\"><i class='thumbs down outline icon'></i>"+downvote+"</div>";*!/
    $('#ratings_like').html('（'+upvote+'票）');
    $('#ratings_diss').html('（'+downvote+'票）');
    $("#grade_Box").html(grade_Box_html);
    $("#doc_Operate").append("<div class='more_reasons'><div id='tag_box_tips'></div>"+more_reasons_str+"</div>")
    /!*$('#submit_tag_box').hide();*!/

    var placeholder_var="创建标签";
    if ($('#session_author_id').html() == $('#page_author_id').html()) {
        if (data.data.tags.length > 0) {
            for(var i=0;i<data.data.tags.length;i++){
                $('#url_tag').append("<li>"+data.data.tags[i].tag_name+"</li>");
                $('#tag_id'+(i+1).toString()).html(data.data.tags[i].tag_id);
                $('#tag_title'+(i+1).toString()).html(data.data.tags[i].tag_name).attr('tag_id',data.data.tags[i].tag_id);
            }
            $("#tag_box_tips").html('');
        }else {
            $("#tag_box_tips").html('为本页面创建一个合适的Tag，更多的人会看到它');
        }
        $("#url_tag").tagit({
            allowSpaces: true,
            removeConfirmation:true,
            autocomplete: {delay: 0, minLength: 0},
            tagLimit:3,
            placeholderText:"qingshuru",
            onTagLimitExceeded : function(event, ui,duringInitialization) {
                alert('最多只能创建3个Tag');
                $(".tagit-new").attr("style","display:block;");
            },
            afterTagAdded:function(event, ui) {
                if($("#url_tag").tagit("assignedTags").length==3){
                    $(".tagit-new").attr("style","display:none;");
                }
                console.log(ui.duringInitialization);
                if(ui.duringInitialization==true )
                {
                    //console.log("init:"+ui.tagLabel+"-"+Date.now());
                }
                else {
                    //console.log("tag add:"+ui.tagLabel+"-"+Date.now());
                    tag_submit("tag add");
                }
            },
            afterTagRemoved:function(event, ui) {
                if($("#url_tag").tagit("assignedTags").length<3){
                    $(".tagit-new").attr("style","display:block;");
                }
                //console.log("tag removed:"+ui.tagLabel+"-"+Date.now());
                tag_submit("tag removed");
            },
            onTagClicked:function(event, ui) {
                console.log(ui.tagLabel);
                var  a=$(".tag_title:contains("+ui.tagLabel+")");
                var visit_tag_id=a.prev().html();
                window.open(host + '/findtag?tagid=' + visit_tag_id + '&&tag_title=' + ui.tagLabel);
            }
        });

        var timer=null;
        $(".ui-autocomplete-input").bind('input propertychange',function(){
            //关于propertychange的trick，2秒内不断刷新同一个setTimeout的内容，实现2秒后触发ajax的延迟效果
            clearTimeout(timer);
            timer=setTimeout(function () {
                $.ajax({
                    type: "POST",   //请求方式
                    url: host+"/page/searchTag",
                    data: {'tag_name': $(".ui-autocomplete-input").val(), 'offset': 0, 'limit': 2},
                    //请求成功
                    success: function (data) {
                        console.log($(".ui-autocomplete-input").val());
                        var availableTags = [];
                        for(var i=0;i<data.data.length;i++){
                            availableTags[i]=data.data[i].tag_name;
                        }
                        $( ".ui-autocomplete-input" ).autocomplete({
                            source: availableTags,
                            minLength:0
                        }).autocomplete("search");
                    },
                    error: function (e) {
                        console.log(e);
                    }
                });
            },2000);

        });
    }
    else {
        if (data.data.tags.length > 0) {
            for(var i=0;i<data.data.tags.length;i++){
                $('#url_tag').append("<li>"+data.data.tags[i].tag_name+"</li>");
                $('#tag_id'+(i+1).toString()).html(data.data.tags[i].tag_id);
                $('#tag_title'+(i+1).toString()).html(data.data.tags[i].tag_name).attr('tag_id',data.data.tags[i].tag_id);
            }
            /!*$("#tag_box_tips").html('');*!/
            placeholder_var=' ';
        }else {
            /!*$("#tag_box_tips").html('本页面还没有创建Tag');*!/
            placeholder_var='该页面暂未创建Tag';
        }
        $("#url_tag").tagit({
            tagLimit:3,
            placeholderText:placeholder_var,
            readOnly:true,
            onTagClicked:function(event, ui) {
                var  a=$("span:contains("+ui.tagLabel+")");
                var visit_tag_id=a.attr('tag_id');
                window.open(host + '/findtag?tagid=' + visit_tag_id + '&&tag_title=' + ui.tagLabel);
            }
        });
        $(".tagit-new").attr("style","display:none;");
    }

    console.log("update_Grade：  DOM updated!");
}*/

/*function update_Recommend(page_id,urltitle,url,tab) {
    $.ajax({
        type : "get",
        url : host + "/page_recommend/list",
        data:{
            'page_id':page_id
        },// 数据

        success : function(data) {

            var doc_Comments_html ="";
            if(data.data.length>0)
            {
                //有评论记录时
                doc_Comments_html+="<span> 您还可以参考：</span>";
                doc_Comments_html+="<span id='wanna_Recommend' class='float-right fa fa-hand-o-up fa-lg' style='line-height: 1em;margin-right: 7em;' ><a id='link_wanna_recommend' class='link_no_decoration cursor_pointer'>我也要推荐</a></span>";
                doc_Comments_html += "<div id=\"doc_Recommend_list\" class=\"float_Left list_style\">";
                doc_Comments_html += "<ul style='padding: 0;'>";
                var reasonStr="";
                var reason_time_minute="";
                for (var i = 0; i < data.data.length; i++) {
                    switch (data.data[i].reason) {
                        case null :reasonStr="暂无标签的资源";break;
                        case "原文链接":reasonStr="原文链接";break;
                        case "更优质":reasonStr="更优质的资源";break;
                        case "更实时":reasonStr="更实时的资源";break;
                        case "问题答疑":reasonStr="问题答疑";break;
                        case "免费":reasonStr="免费的资源";break;
                    }

                    reason_time_minute=timestampToPublishTips(data.data[i].create_time);
                    var imagestr="";
                    if(data.data[i].avatar==""||data.data[i].avatar==null){
                        imagestr="images/avatar/u1.png";
                    }
                    else {
                        imagestr="images/avatar/"+data.data[i].avatar;
                        if(data.data[i].avatar.indexOf('ax1x')>0){
                            imagestr=data.data[i].avatar;
                        }else if(data.data[i].avatar.indexOf('http')==0){
                            imagestr=data.data[i].avatar;
                        }

                    }
                    doc_Comments_html += "<li><img src='"+imagestr+"'></img><div class='recommend_list_div'><div><a class='link_to_user_homepage' author_id='"+data.data[i].author_id+"' author='"+data.data[i].author+"'>"+data.data[i].author+"</a> 推荐访问 <a target='_blank' href='http://"+data.data[i].recommend_url+"'> "+reasonStr+"</a>"+"</div><div class='recommend_sub'><span class='recommend_pbtime'>"+reason_time_minute+"</span><!--<span  class='recommend_like_num fa fa-thumbs-up'>9</span>--></div></div></li>";
                }
                doc_Comments_html += "</ul></div>";
                $("#doc_Comments").html(doc_Comments_html);//拼装完的内容更新回插件
                $("#link_wanna_recommend").click(function () {
                    window.open(host+'/page_recommend/index?pageid='+page_id+"&urltitle="+$('#new_title_box').html()+"&url="+url);
                });
                $(".link_to_user_homepage").click(function () {
                    window.open(host+'/homepage?author_id='+$(this).attr('author_id')+"&&author="+encodeURI(encodeURI($(this).attr('author'))));
                });
            }
            else
            {
                //无评论记录时
                doc_Comments_html +="<span id='wanna_Recommend'>";
                doc_Comments_html +=    "<a id='link_wanna_recommend2' class='link_no_decoration cursor_pointer'>当前主题有更好的资料<span>推荐</span>吗？点我！</a>";
                doc_Comments_html +="</span>";
                $("#doc_Comments").html(doc_Comments_html);//拼装完的内容更新回插件
                $("#link_wanna_recommend2").click(function () {
                    window.open(host+'/page_recommend/index?pageid='+page_id+"&urltitle="+$('#new_title_box').html()+"&url="+url);
                });
            }
        },
        error : function(e){
            console.log("comments api wrong");
        }
    });
}*/

/*function tag_submit(caller) {
    //console.log(caller + " CALLED tag_submit" + "-" + Date.now());
    $('#page_id_form_input').val($('#page_id').html());
    if ($("#url_tag").tagit("assignedTags").length == 0) {
        alert("至少需要标记一个Tag");
        return;
    }
    var postData = $("#form_tags").serializeArray();
    var formURL = host + "/tag/updatePageTag";
    $.ajax({
        url: formURL,
        type: "POST",
        data: postData,

        success: function (data) {
            var j=$("#url_tag").tagit("assignedTags").length;
            for(var i=0;i<j;i++)
            {
                $('#tag_id'+(i+1)).html(data.data[i].tag_id);
                $('#tag_title'+(i+1)).html(data.data[i].tag_name);
            }
            if(caller=="tag add"){
                $('.tagit-label:contains('+data.data[j-1].tag_name+')').parent().animate({backgroundColor:'#ff7940',opacity:'0.8'},"fast").animate({backgroundColor:'#f2f2f2'},"fast");
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            alert('Tag更新失败，请重试');
        }
    });
}*/

/*获取页面的评论数据*/
function get_page_comments(page_id){
    $.ajax({
        type : "GET",
        contentType: "application/json;charset=UTF-8",
        url : host + "/page_comment/list?page_id=" + page_id,
        success : function(data) {
            var str="";
            if(data.data.length>0)
            {
                $('#fa-comments').attr('style','color:#07AB56');
                $('#fa-comments').html(data.data.length.toString());
                $('#fa-comments').click(function () {
                    $('.comments').removeClass('hidden');
                });
                for(var i=0;i<data.data.length;i++){
                    $('.commentlist').html('');
                    if(data.data[i].avatar!=null&&data.data[i].avatar.indexOf('://')>0){
                        str+="<div class='comment'><a class='avatar' href='" + host + "/my/user/" + data.data[i].author_id + "' target='_blank'><img src='";
                        str+=data.data[i].avatar;
                    }else {
                        str+="<div class='comment'><a class='avatar' href='" + host + "/my/user/" + data.data[i].author_id + "' target='_blank'><img src='/images/avatar/";
                        if(data.data[i].avatar==null)
                        {
                            str+='u1.png';
                        }
                        else {
                            str+=data.data[i].avatar;
                        }

                    }
                    str+="'></a><div class='content'><a class='author' href='" + host + "/my/user/" + data.data[i].author_id + "' target='_blank'>";
                    str+=data.data[i].author_name;
                    str+="</a><div class='metadata'><span class='date'>";
                    str+=getTimeShow(data.data[i].create_time);
                    str+="</span></div><div class='text'>";
                    str+=data.data[i].body+"</div></div></div>";

                    $('.commentlist').html(str);
                }
            }
            else {
                $('.commentlist').html('');
                $('#fa-comments').click(function () {
                    $('.comments').removeClass('hidden');
                });

            }
        },
        error : function(e){
            console.log(e.status);
            console.log(e.responseText);
        }
    });
}

/*发表评论*/
function page_comment_add(page_id,content) {
    // 清除之前的提示信息
    $('#comment_tip').remove();
    
    $('#comment_submit').html("<img src='../images/loading.gif' style='height:30px;'>");
    $('#comment_submit').removeClass('ui blue labeled submit icon mini button');
    console.log('page_id:'+page_id+',content:'+content);
    $.ajax({
        type: "POST",
        url: host + "/page_comment/add",
        data: {
            'page_id': page_id,
            'content': content
        },
        success: function (data) {
            console.log("评论提交响应：", data);
            
            if (data.code === 200 || data.code === "200") {
                // 成功提交
                $('#comments_content').val('');
                // 确保评论区可见
                $('.comments').removeClass('hidden');
                // 正确使用 setTimeout
                setTimeout(function() {
                    get_page_comments(page_id);
                }, 1000);
                
                // 显示成功提示
                show_comment_tip("评论发表成功！", "success");
            } else {
                // 服务器返回错误信息
                var errorMsg = data.message || data.msg || "评论发表失败";
                show_comment_tip(errorMsg, "error");
                console.log("评论提交失败：", errorMsg);
            }

            $('#comment_submit').html("<i class=\"icon edit\"></i> 发表评论");
            $('#comment_submit').addClass('ui blue labeled submit icon mini button');
        },
        error: function (e) {
            console.log(e.status);
            console.log(e.responseText);
            
            // 尝试解析错误响应中的信息
            var errorMsg = "网络错误，请稍后重试";
            try {
                if (e.responseText) {
                    var errorData = JSON.parse(e.responseText);
                    errorMsg = errorData.message || errorData.msg || errorMsg;
                }
            } catch (parseError) {
                console.log("解析错误响应失败:", parseError);
            }
            
            show_comment_tip(errorMsg, "error");
            
            // 发生错误时恢复按钮状态
            $('#comment_submit').html("<i class=\"icon edit\"></i> 发表评论");
            $('#comment_submit').addClass('ui blue labeled submit icon mini button');
        }
    });
}

/*显示评论提示信息*/
function show_comment_tip(message, type) {
    // 移除之前的提示
    $('#comment_tip').remove();
    
    // 创建提示元素
    var tipClass = type === "success" ? "ui green message" : "ui red message";
    var tipHtml = '<div id="comment_tip" class="' + tipClass + '" style="margin-top: 5px; padding: 8px 12px; font-size: 12px;">' + 
                  '<i class="' + (type === "success" ? "checkmark" : "warning") + ' icon"></i>' + 
                  message + '</div>';
    
    // 在评论提交按钮后面插入提示
    $('#comment_submit').after(tipHtml);
    
    // 3秒后自动隐藏提示
    setTimeout(function() {
        $('#comment_tip').fadeOut(500, function() {
            $(this).remove();
        });
    }, 3000);
}

/*根据不同情况初始化主题标签input*/
function theme_config(page_id) {
    console.log("theme_config被调用，pageID:"+page_id);
    if(page_id!="")
    {
        $.ajax({
            type: "POST",
            url: host + "/page/getThemeNameByPage",
            data: {
                'page_id': page_id
            },
            success: function (data) {
                if(data.code=="200"){
                    // 有值，填充并进入已创建状态（按钮样式，提交按钮隐藏）
                    console.log('后台已搜索到创建的主题标签为：'+data.msg);
                    $('#theme_tag').val(data.msg);
                    $('#created_theme').html(data.msg);
                    theme_input_state_change($('#theme_tag'),"created",'hide');
                    $('.theme_tag_box').removeClass('hidden').animate({opacity:'1'},"fast");
                } else {
                    // 无值，进入编辑状态（输入框样式，提交按钮显示）
                    console.log("页面已创建，但没有创建主题标签");
                    theme_input_state_change($('#theme_tag'),'edit','show');
                    $('.theme_tag_box').removeClass('hidden').animate({opacity:'1'},"fast");
                }
            },
            error: function (e) {
                console.log("获取主题标签失败");
                console.log(e.status);
                console.log(e.responseText);
            }
        });
    }
}

/*主题标签input的状态转移函数*/
function theme_input_state_change(obj,state,btnDisplay){
    console.log("theme_input_state_change方法被调用，state="+state+",display="+btnDisplay+",time:"+log_timer());
    
    // 先解绑之前的所有点击事件
    $("#theme_tag_submit").off('click');
    
    if(state=="edit"){
        console.log("theme_input_state_change————标签进入edit模式，input样式完成设定");
        $(obj).css({"border":"1px solid #2185d0","color":"#000","background-color":"#fff",'height':'30px'});

        if($('#created_theme').html()!="")
        {
            console.log('#theme_tag_submit已设定为激发updatePageTheme行为');
            $("#theme_tag_submit").on('click', function () {
                if($('#page_id').html()==""){
                    alert('请先完成点赞或吐槽')
                    return;
                }
                if($('#theme_tag').val()==$('#created_theme').html())
                {
                    search();
                    return;
                }
                if($('#theme_tag').val()=="")
                {
                    alert('请输入合适的主题标签')
                    return;
                }
                $.ajax({
                    type: "POST",
                    url: host + "/page/updatePageTheme",
                    data: {
                        'page_id': $('#page_id').html(),
                        'theme_name': $('#theme_tag').val()
                    },
                    success: function (data) {
                        console.log("theme_input_state_change——标签更新成功，input即将进入created模式，hide");
                        theme_input_state_change($('#theme_tag'), "created",'hide');
                        $('#created_theme').html($('#theme_tag').val());
                    },
                    error: function (e) {
                        console.log(e.status);
                        console.log(e.responseText);
                    }
                });
            });
        }
        else {
            console.log('theme_input_state_change——#created_theme为空，#theme_tag_submit已设定为等待激发addPageTheme行为');
            $("#theme_tag_submit").on('click', function () {
                if($('#page_id').html()==""){
                    alert('请先完成点赞或吐槽')
                    return;
                }
                if($('#theme_tag').val()=="")
                {
                    alert('请输入合适的主题标签')
                    return;
                }
                $.ajax({
                    type: "POST",
                    url: host + "/page/addPageTheme",
                    data: {
                        'page_id': $('#page_id').html(),
                        'theme_name': $('#theme_tag').val()
                    },
                    success: function (data) {
                        console.log("theme_input_state_change——标签提交成功，input即将进入created模式，hide");
                        theme_input_state_change($('#theme_tag'), "created",'hide');
                        $('#created_theme').html($('#theme_tag').val());
                    },
                    error: function (e) {
                        console.log(e.status);
                        console.log(e.responseText);
                    }
                });
            });
        }
    }
    /*如果进入created状态，则input变为背景模式，代表已经创建成功，此时插件隐藏submit按钮，并给input加入focus事件，等待激活并再次显示submit按钮*/
    if(state=="created"){
        console.log("标签进入created模式");
        $('#theme_tag').css({"border":"1px solid #2185d0","color":"#fff","background-color":"#2185d0",'height':'30px'});
        $("#theme_tag_submit").addClass('hidden');
        $('#theme_tag').off('focus').on('focus', function () {
            theme_input_state_change('#theme_tag',"edit",'show');
            $('#theme_tag').attr('placeholder','');
        });
    }

    if(btnDisplay=='show'){
        $("#theme_tag_submit").removeClass('hidden');
    }
    if(btnDisplay=='hide'){
        $("#theme_tag_submit").addClass('hidden');
    }
}

/*获取页面自定义标题*/
function get_page_custom_title(page_id) {
    console.log("开始获取页面自定义标题");
    console.log("page_id = " + page_id);
    
    if(page_id != "") {
        // 确保先获取到用户信息
        $.ajax({
            type: "get",
            url: host + "/my/info",
            success: function(userResponse) {
                if(userResponse.code == "200") {
                    var user_id = userResponse.data.my_user_id;
                    console.log("当前用户ID = " + user_id);
                    
                    // 获取到用户ID后再请求 mytitle
                    $.ajax({
                        type: "GET",
                        url: host + "/api/mytitle/page/" + page_id,
                        success: function(data) {
                            console.log("获取自定义标题响应数据：", data);
                            
                            if (data.code === 200) {
                                if (data.data && Array.isArray(data.data)) {
                                    // 过滤出当前用户的记录
                                    const userMytitles = data.data.filter(item => parseInt(item.creator_id) === parseInt(user_id));
                                    console.log("当前用户ID: " + user_id + ", 过滤后的自定义标题数据：", userMytitles);
                                    
                                    if (userMytitles && userMytitles.length > 0) {
                                        const mytitleData = userMytitles[0];
                                        console.log("找到当前用户的自定义标题：", mytitleData.mytitle);
                                        // 有值，填充并进入已创建状态
                                        $('#custom_title').val(mytitleData.mytitle);
                                        $('#created_custom_title').html(mytitleData.mytitle);
                                        // 保存 mytitle id
                                        $('#mytitle_id').html(mytitleData.id);
                                        custom_title_state_change("created", "hide");
                                        $('.custom_title_box').removeClass('hidden').animate({opacity:'1'}, "fast");
                                    } else {
                                        console.log("未找到当前用户(" + user_id + ")的自定义标题数据");
                                        // 无值，隐藏自定义标题区域
                                        $('.custom_title_box').addClass('hidden');
                                    }
                                } else {
                                    console.log("返回的数据格式不正确");
                                    $('.custom_title_box').addClass('hidden');
                                }
                            } else if (data.code === 401) {
                                console.log("用户未登录");
                                $('.custom_title_box').addClass('hidden');
                            } else {
                                console.log("获取自定义标题失败，错误码：", data.code);
                                $('.custom_title_box').addClass('hidden');
                            }
                        },
                        error: function(e) {
                            console.log("获取自定义标题请求失败");
                            console.log("错误状态：", e.status);
                            console.log("错误信息：", e.responseText);
                            $('.custom_title_box').addClass('hidden');
                        }
                    });
                } else {
                    console.log("获取用户信息失败");
                    $('.custom_title_box').addClass('hidden');
                }
            },
            error: function(e) {
                console.log("获取用户信息请求失败");
                $('.custom_title_box').addClass('hidden');
            }
        });
    } else {
        console.log("page_id 为空，无法获取自定义标题");
        $('.custom_title_box').addClass('hidden');
    }
}

/*自定义标题状态切换函数，参考 theme_input_state_change*/
function custom_title_state_change(state, btnDisplay) {
    console.log("custom_title_state_change 方法被调用，state=" + state + ", display=" + btnDisplay);
    
    if (state == "edit") {
        // 编辑状态：输入框样式为正常输入状态
        $('#custom_title').css({
            "border": "1px solid #2185d0",
            "color": "#000",
            "background-color": "#fff",
            "height": "30px"
        });

        if($('#created_custom_title').html() != "") {
            $("#custom_title_submit").click(function () {
                if($('#page_id').html() == "") {
                    alert('请先完成点赞或吐槽');
                    return;
                }
                if($('#custom_title').val() == $('#created_custom_title').html()) {
                    return;
                }
                if($('#custom_title').val() == "") {
                    alert('请输入自定义标题');
                    return;
                }
                update_page_custom_title($('#page_id').html());
            });
        }
    }
    
    if (state == "created") {
        // 已创建状态：输入框样式类似按钮状态
        $('#custom_title').css({
            "border": "1px solid #2185d0",
            "color": "#fff",
            "background-color": "#2185d0",
            "height": "30px"
        });
        $("#custom_title_submit").addClass('hidden');
        $('#custom_title').focus(function () {
            custom_title_state_change("edit", "show");
            $('#custom_title').attr('placeholder', '');
            $('#custom_title').unbind('focus');
        });
    }
    
    // 控制确定按钮的显示与隐藏
    if (btnDisplay == 'show') {
        $("#custom_title_submit").removeClass('hidden');
    }
    if (btnDisplay == 'hide') {
        $("#custom_title_submit").addClass('hidden');
    }
}

/*更新页面自定义标题*/
function update_page_custom_title(page_id) {
    var newTitle = $('#custom_title').val();
    var mytitle_id = $('#mytitle_id').html();
    console.log("更新页面自定义标题：page_id = " + page_id + ", newTitle = " + newTitle + ", mytitle_id = " + mytitle_id);
    
    if (newTitle.trim() == "") {
        alert("请输入自定义标题");
        return;
    }
    
    // 获取当前用户ID
    var user_id = $('#my_user_id_from_session').text() || 32; // 如果获取不到，默认使用32
    
    // 使用 mytitle_id 调用更新接口
    $.ajax({
        type: "PUT",
        url: host + "/api/mytitle/" + mytitle_id,
        contentType: "application/json",
        data: JSON.stringify({
            "mytitle": newTitle,
            "modifier_id": parseInt(user_id),
            "page_id": parseInt(page_id)
        }),
        success: function(data) {
            console.log("更新自定义标题成功：" + JSON.stringify(data));
            if (data.code === 200) {
                // 更新成功后，切换到已创建状态，隐藏确定按钮
                custom_title_state_change("created", "hide");
                $('#created_custom_title').html(newTitle);
                
                // 重新绑定输入框的 focus 事件
                $('#custom_title').off('focus').on('focus', function() {
                    custom_title_state_change("edit", "show");
                    $(this).off('focus');
                });
            } else {
                alert("更新失败：" + data.msg);
                console.log("更新自定义标题失败，错误信息：" + data.msg);
            }
        },
        error: function(e) {
            console.log("更新自定义标题失败");
            console.log(e.status);
            console.log(e.responseText);
            alert("更新失败，请稍后重试！");
        }
    });
}
