function log_timer() {
    return new Date().toLocaleString()+" ."+new Date().getSeconds()+" ."+new Date().getMilliseconds();
}

function formatUnixtimestamp (unixtimestamp,type){
    var unixtimestamp = new Date(unixtimestamp*1000);
    var year = 1900 + unixtimestamp.getYear();
    var month = "0" + (unixtimestamp.getMonth() + 1);
    var date = "0" + unixtimestamp.getDate();
    var hour = "0" + unixtimestamp.getHours();
    var minute = "0" + unixtimestamp.getMinutes();
    var second = "0" + unixtimestamp.getSeconds();
    if(type==="YYMMdd")
    {
        year=year.toString();
        return year.substring(year.length-2, year.length)+"-"+month.substring(month.length-2, month.length)  + "-" + date.substring(date.length-2, date.length);
    }
    else if(type=="YYYYMMdd"){
        return year+"-"+month.substring(month.length-2, month.length)  + "-" + date.substring(date.length-2, date.length);
    }
    else if(type=="FullFormat")
    {
        return year + "-" + month.substring(month.length-2, month.length)  + "-" + date.substring(date.length-2, date.length)
            + " " + hour.substring(hour.length-2, hour.length) + ":"
            + minute.substring(minute.length-2, minute.length) + ":"
            + second.substring(second.length-2, second.length);
    }
}

function timestampToPublishTips(create_time) {

    var reason_time_minute=0;
    reason_time_minute = (new Date().getTime()-create_time)/(60000);

    reason_time_minute=Math.ceil(reason_time_minute);
    if(reason_time_minute<60){
            reason_time_minute=reason_time_minute+"分钟前";
        }
    else if(60<=reason_time_minute&&reason_time_minute<60*24){
        reason_time_minute=Math.floor(reason_time_minute/(60))+"小时前";
    }
    else if(60*24<=reason_time_minute&&reason_time_minute<60*24*7) {
        reason_time_minute=Math.floor(reason_time_minute/(60*24))+"天前";
    }
    else{
        reason_time_minute=formatUnixtimestamp(create_time/1000,"YYYYMMdd");
    }
    return reason_time_minute;
}


function process_title(url, title){
    if(title.endsWith(' - 知乎')){
        title = title.substring(0, title.length-5);
        $('#title_process_flag').html('1');
    }
    if(title.endsWith(' - 博客园')){
        title = title.substring(0, title.length-6);
        $('#title_process_flag').html('1');
    }
    if(title.endsWith(' - 简书')){
        title = title.substring(0, title.length-5);
        $('#title_process_flag').html('1');
    }
    if(title.endsWith(' - 中国知网')){
        title = title.substring(0, title.length-7);
        $('#title_process_flag').html('1');
    }
    if(title.indexOf('条消息) ') > 0){
        $('#title_process_flag').html('1');
        title = title.substring(title.indexOf('条消息) ')+ 5)
    }
    return title
}



const getTimeShow = (time_str)=>{


    var now = new Date();
    time_str=time_str.substring(0,time_str.length-3);
    console.log(time_str);
    var date = new Date(time_str);



//计算时间间隔，单位为分钟

    var inter = parseInt((now.getTime() - date.getTime())/1000/60);

    if(inter == 0){

        return "刚刚";

    }

//多少分钟前

    else if(inter < 60){

        return inter.toString() + "分钟前";

    }

//多少小时前

    else if(inter < 60*24){

        return parseInt(inter/60).toString() + "小时前";

    }

//本年度内，日期不同，取日期+时间  格式如  06-13 22:11

    else if(now.getFullYear() == date.getFullYear()){

        return (date.getMonth()+1).toString() + "-" +

            date.getDate().toString() + " " +

            date.getHours() + ":" +

            date.getMinutes();

    }

    else{

        return date.getFullYear().toString().substring(2, 3) + "-" +

            (date.getMonth()+1).toString() + "-" +

            date.getDate().toString() + " " +

            date.getHours() + ":" +

            date.getMinutes();

    }

}
