// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

if (typeof chrome !== 'undefined' && chrome.runtime && chrome.runtime.onInstalled) {
chrome.runtime.onInstalled.addListener(function() {
  // chrome.storage.sync.set({color: '#3aa757'}, function() {
  //   console.log("The color is green.");
  // });
 

  // 简化：仅启用 action，避免 declarativeContent 在某些环境未实现导致注册失败
  try {
    if (chrome.action && chrome.action.enable) {
      chrome.action.enable();
    }
  } catch (e) {
    console.warn('action.enable failed:', e);
  }

});
}

// 注意：chrome.runtime.onError 在 MV3 中不存在，故不注册