# DOI改造测试说明

## 改造完成的功能

### 1. DOI提取函数
- 位置：`popup.js` 第4-25行
- 功能：从页面HTML中提取DOI信息
- 支持格式：
  - `DOI: 10.3964/j.issn.1000-0593(2025)08-2101-09`
  - `10.1126/sciadv.adr9635`
  - `doi: 10.27379/d.cnki.gwhdu.2024.000077`

### 2. 查询逻辑改造
- 位置：`search()` 函数
- 逻辑：优先使用DOI查询，无DOI时使用URL查询
- 接口调用：
  - 有DOI：`/peanut?doi=xxx`
  - 无DOI：`/peanut?url=xxx`

### 3. 页面创建改造
- 位置：`page_add()` 函数
- 功能：创建页面时同时发送DOI和URL字段
- 数据格式：
  ```json
  {
    "url": "页面URL",
    "title": "页面标题",
    "doi": "DOI标识符（如果存在）"
  }
  ```

## 本地测试步骤

### 1. 环境准备
- 确保本地后端服务运行在 `http://127.0.0.1:5000`
- 后端需要支持新的DOI查询参数

### 2. 测试场景

#### 场景1：有DOI的学术页面
- 访问包含DOI的学术文献页面
- 激活插件，查看控制台日志
- 应该看到："使用DOI查询: xxx"
- 后端应该收到：`/peanut?doi=xxx`

#### 场景2：无DOI的普通页面
- 访问普通网页（如新闻、博客等）
- 激活插件，查看控制台日志
- 应该看到："未检测到DOI信息"
- 应该看到："使用URL查询: xxx"
- 后端应该收到：`/peanut?url=xxx`

#### 场景3：创建新页面
- 在无记录的页面上点击点赞/吐槽
- 查看后端日志，应该收到包含DOI字段的POST请求

### 3. 控制台日志检查
插件激活时应该看到：
```
Search() 开始执行
开始提取DOI信息...
成功提取DOI: 10.xxx/xxx  (如果有DOI)
或
未检测到DOI信息
使用DOI查询: xxx  (如果有DOI)
或
使用URL查询: xxx  (如果无DOI)
```

### 4. 后端接口要求

#### GET /peanut
- 支持 `?doi=xxx` 参数
- 支持 `?url=xxx` 参数
- 返回格式保持不变

#### POST /page/add
- 新增 `doi` 字段（可选）
- 其他字段保持不变

## 注意事项

1. **向后兼容**：所有基于page_id的接口保持不变
2. **DOI格式**：目前支持标准DOI格式（10.xxx/xxx）
3. **错误处理**：如果DOI提取失败，自动降级到URL查询
4. **性能考虑**：DOI提取使用正则表达式，性能较好

## 下一步工作

1. 测试DOI提取的准确性
2. 验证后端接口的兼容性
3. 根据测试结果调整DOI提取规则
4. 考虑添加更多DOI格式支持
